#!/bin/python /home/chris/data/Skripte/python_lib/runInKonsole.py

import sys,os,json,csv,tempfile,shutil,configparser
from pathlib import PosixPath as Path

from pprint import PrettyPrinter
pp = PrettyPrinter(sort_dicts=False,width=os.get_terminal_size()[0]-1).pprint

from SunBlade import fs,con,proc

SCRIPT_DIR = Path(__file__).absolute().parent.resolve()
BASE_DIR = Path(__file__).absolute().parent.parent.resolve()
MOD_NAME = 'sbSortedLogistics'



def read_csv(path:Path)->list[dict[str,str]]:
	with path.open('rt',newline='') as csvfile:
		return list(csv.DictReader(csvfile))

def read_ini(path:Path)->dict[str,dict[str,str]]:
	cfg = configparser.ConfigParser(default_section=None)
	cfg.optionxform = str
	if cfg.read(path):
		return { s:{ k:v for k,v in cfg.items(s,raw=True) } for s in cfg.sections() }

def dict_to_ini(ini:dict[str,dict[str,str]])->str:
	return '\n'.join( '[{0}]\n{1}\n'.format(s,'\n'.join( '{0}={1}'.format(k,v) for k,v in sec.items() )) for s,sec in ini.items() )


def add_translation(db:dict[str,dict[str,dict[str,str]]])->list[dict[str,str]]:
	conv = {
		('sort','name'):	(f'{MOD_NAME}-name','btn-sort-'),
		('sort','desc'):	(f'{MOD_NAME}-desc','btn-sort-'),
		('auto','name'):	('mod-setting-name',f'{MOD_NAME}-sort-'),
		('auto','desc'):	('mod-setting-description',f'{MOD_NAME}-sort-'),
	}
	out = list()
	lst = read_csv(SCRIPT_DIR/'lang.csv')
	for e in lst:
		if e['auto_name_en']!='' or e['auto_name_de']!='' or e['auto_desc_en']!='' or e['auto_desc_de']!='':
			out.append((int(e['order']),'\t"{}",\t-- {}'.format(e['name'],e['type'])))
		for key,value in e.items():
			if value!='' and key.count('_')==2:
				s,k,l = key.split('_')
				s,k = conv[s,k]
				db[l][s]['{}{}'.format(k,e['name'])] = value.replace('\n',r'\n')
	return [ e[1] for e in sorted(out) ]

def main(*args:str)->int:
	db = dict()
	for locale_file in SCRIPT_DIR.glob('lang_*.ini'):
		db[locale_file.stem[5:]] = read_ini(locale_file)

	lst = add_translation(db)

	for lang,ini in db.items():
		(BASE_DIR/f'locale/{lang}/{MOD_NAME}.cfg').write_text(dict_to_ini(ini))

	pp(lst)

	Path(__file__).with_suffix('.txt').write_text('\n'.join(lst))
	return 1



if __name__ == "__main__":
	sys.exit(main(*sys.argv[1:]))