local pairs = pairs
local arr_insert = table.insert

local tbl = {
	{
		type = "custom-input",
		name = "sbSortedLogistics-toggle",
		consuming = "game-only",
		order = "sbSortedLogistics_hk01",
		key_sequence = "",
	},{
		type = "custom-input",
		name = "sbSortedLogistics-enable",
		consuming = "game-only",
		order = "sbSortedLogistics_hk02",
		key_sequence = "",
	},{
		type = "custom-input",
		name = "sbSortedLogistics-disable",
		consuming = "game-only",
		order = "sbSortedLogistics_hk03",
		key_sequence = "",
	},{
		type = "shortcut",
		name = "sbSortedLogistics-toggle",
		order = "sbSortedLogistics_sc01",
		associated_control_input = "sbSortedLogistics-toggle",
		action = "lua",
		icon = "__core__/graphics/icons/mod-manager/cubes.png",
		icon_size = 32,
		small_icon = "__core__/graphics/icons/mod-manager/cubes.png",
		small_icon_size = 32,
		toggleable = true,
		style = "green",
	}
}

local num = 9
for _,hkn in pairs{"self","car","opened","target","hand"} do
	for _,hks in pairs{"","-full"} do
		num = num + 1
		arr_insert(tbl,{
			type = "custom-input",
			name = "sbSortedLogistics-sort-"..hkn..hks,
			consuming = "game-only",
			order = "sbSortedLogistics_hk"..num,
			key_sequence = "",
		})
	end
end

data:extend(tbl)