#!/bin/python /home/chris/data/Skripte/python_lib/runInKonsole.py

import sys,os,json,csv,tempfile,shutil,configparser
from pathlib import PosixPath as Path

from pprint import PrettyPrinter
pp = PrettyPrinter(sort_dicts=False,width=os.get_terminal_size()[0]-1).pprint

from SunBlade import fs,con,proc


BASE_DIR = Path(__file__).absolute().parent



def main(*args:str)->int:
	with open('classes.csv','rt', newline='') as csvfile:
		db = list(csv.DictReader(csvfile))
	# pp(db)

	out = list()
	inv_list = ('fuel','waste','main','trash','aux','module')

	cfg={}
	lst={}
	for e in db:
		if e['special'] == 'ntt' and e['class'] != '' and e['type'] != '':
			cfg[e['class']] = list(inv_list)
			lst.setdefault(e['class'],dict())[e['type']] = [ e[t] if e[t]!='' else None for t in inv_list ]
	for c,cls in lst.items():
		for n in range(len(inv_list)-1,-1,-1):
			if all( not v[n] for v in cls.values() ):
				for v in cls.values(): v.pop(n)
				cfg[c].pop(n)

	pp(lst)

	out.append('local cfg_inventories = {')
	for c,cls in lst.items():
		for t,v in cls.items():
			if len(v)>=1:
				out.append('\t["{}"] =\t{{ {} }},'.format(t, ', '.join(map(lambda x: 'defines.inventory.{}'.format(x) if x else 'nil',v)) ))
	out.append('}')

	out.append('local cfg_type_map = {')
	out.extend(map('\t["{}"] =\t"{}",'.format,*zip(*sorted({
		e['type']:e['class'] for e in db if e['class'] != '' and e['type'] != ''
	}.items()))))
	out.append('}')

	out.append('local cfg_inv_options = {')
	out.extend(map('\t"{}",\t-- {}'.format,*zip(*sorted({
		'{}{}'.format(c,k+1):v for c,cls in cfg.items() for k,v in enumerate(cls)
	}.items()))))
	out.append('}')

	out.append('local cfg_logi_options = {')
	out.extend(map('\t"{}",'.format,sorted({
		e['class'] for e in db if e['special'] == 'ntt'
	})))
	out.append('}')



	out.extend(['','',''])
	lst = { e['class']:e['special'] for e in db if e['class'] != '' and e['special'] != '' }
	lst |= { '{}{}'.format(c,k+1):v for c,cls in cfg.items() for k,v in enumerate(cls) }
	out.extend(map('\t"{}",\t-- {}'.format,*zip(*sorted(lst.items()))))



	# pp(lst)
	# pp(cfg)

	Path(__file__).with_suffix('.txt').write_text('\n'.join(out))

	return 1



if __name__ == "__main__":
	sys.exit(main(*sys.argv[1:]))