--	kate: indent-width 6; tab-width 6;

local tbl = {
	{
		type = "bool-setting",
		name = "sbSortedLogistics-enabled",
		setting_type = "runtime-per-user",
		default_value = true,
		order = "a001",
	},{
		type = "string-setting",
		name = "sbSortedLogistics-gui-show",
		setting_type = "runtime-per-user",
		default_value = "always",
		allowed_values = {
			"always",
			"auto",
			"mini",
			"never",
		},
		order = "a002",
	},{
		type = "string-setting",
		name = "sbSortedLogistics-gui-position",
		setting_type = "runtime-per-user",
		default_value = "type",
		allowed_values = {
			"none",
			"typ",
			"type",
			"name",
			"fix",
		},
		order = "a003",
	}
}

for k,v in pairs{
	"self1",	-- main
	"self2",	-- trash
	"self3",	-- aux
	"self",	-- ntt
	"player1",	-- main
	"player2",	-- trash
	"player3",	-- aux
	"player",	-- ntt

	"chest1",	-- main
	"chest2",	-- trash
	"chest",	-- ntt
	"space1",	-- main
	"space2",	-- trash
	"space",	-- ntt
	"car1",	-- fuel
	"car2",	-- main
	"car3",	-- trash
	"car",	-- ntt
	"crafter1",	-- fuel
	"crafter2",	-- module
	"crafter",	-- ntt
	"reactor1",	-- fuel
	"reactor2",	-- waste
	"reactor",	-- ntt
	"robo1",	-- main
	"robo2",	-- aux
	"robo",	-- ntt
	"rocket1",	-- fuel
	"rocket2",	-- main
	"rocket3",	-- trash
	"rocket4",	-- module
	"rocket",	-- ntt
	"train1",	-- main
	"train",	-- ntt
	"math",	-- ntt
	"other",	-- meta

	"infinity",	-- meta

	"decon",	-- item
	"upgrade",	-- item
	"book",	-- item
	"books",	-- meta
	"item",	-- item

	"scriptinv",	-- meta
} do
	table.insert(tbl,{
		type = "bool-setting",
		name = "sbSortedLogistics-sort-"..v,
		setting_type = "runtime-per-user",
		default_value = false,
		order = string.format("s%03d",k),
	})
end

data:extend(tbl)